/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VWConfigGeneralPane
extends JPanel {
    private static final ImageIcon cQueueIcon = VWImageLoader.createImageIcon("q_comp_32.gif");
    private static final ImageIcon wQueueIcon = VWImageLoader.createImageIcon("q_work_32.gif");
    private static final ImageIcon uQueueIcon = VWImageLoader.createImageIcon("q_user_32.gif");
    private static final ImageIcon rosterIcon = VWImageLoader.createImageIcon("roster_32.gif");
    private static final ImageIcon logIcon = VWImageLoader.createImageIcon("eventlog_32.gif");
    private static final ImageIcon appSpaceIcon = VWImageLoader.createImageIcon("appspace_32.gif");
    private JTextArea m_descriptionTextArea = new JTextArea();
    private String m_oldDescription = null;

    public VWConfigGeneralPane(String name, String category, String type, int serverId, String description) {
        try {
            this.m_oldDescription = description;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.fill = 2;
            gbConst.gridwidth = 0;
            gbConst.anchor = 23;
            gbConst.gridheight = 1;
            gbConst.gridx = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.createIconPanel(category, type), gbConst);
            this.add((Component)this.createTopPanel(name, category, type, serverId), gbConst);
            gbConst.fill = 1;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            JPanel panel = this.createDescriptionPanel(description);
            this.add((Component)panel, gbConst);
            panel.getAccessibleContext().setAccessibleParent(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getDescription() {
        if (this.m_descriptionTextArea != null) {
            return this.m_descriptionTextArea.getText();
        }
        return null;
    }

    public boolean isModified() {
        boolean bNewDescIsNull;
        boolean bIsModified = false;
        String sDescription = this.getDescription();
        boolean bOrgDescIsNull = this.m_oldDescription == null || this.m_oldDescription.length() == 0;
        boolean bl = bNewDescIsNull = sDescription == null || sDescription.length() == 0;
        if (!bNewDescIsNull && !bOrgDescIsNull) {
            bIsModified = VWStringUtils.compare(this.m_oldDescription, this.getDescription()) != 0;
        } else if (bNewDescIsNull && !bOrgDescIsNull || !bNewDescIsNull && bOrgDescIsNull) {
            bIsModified = true;
        }
        return bIsModified;
    }

    public void releaseResources() {
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        this.m_oldDescription = null;
        this.removeAll();
    }

    private JPanel createIconPanel(String category, String type) {
        try {
            JPanel iconPanel = new JPanel(new BorderLayout(4, 4));
            JLabel iconLabel = null;
            if (VWStringUtils.compare(category, VWResource.Queue) == 0) {
                if (VWStringUtils.compare(type, VWResource.UserCentric) == 0) {
                    iconLabel = new JLabel(uQueueIcon);
                    VWAccessibilityHelper.setAccessibility(iconLabel, this, VWResource.UserCentricQueue, VWResource.UserCentricQueue);
                } else if (VWStringUtils.compare(type, VWResource.Work) == 0) {
                    iconLabel = new JLabel(wQueueIcon);
                    VWAccessibilityHelper.setAccessibility(iconLabel, this, VWResource.WorkQueue, VWResource.WorkQueue);
                } else if (VWStringUtils.compare(type, VWResource.Component) == 0) {
                    iconLabel = new JLabel(cQueueIcon);
                    VWAccessibilityHelper.setAccessibility(iconLabel, this, VWResource.ComponentQueue, VWResource.ComponentQueue);
                }
            } else if (VWStringUtils.compare(category, VWResource.Roster) == 0) {
                iconLabel = new JLabel(rosterIcon);
                VWAccessibilityHelper.setAccessibility(iconLabel, this, VWResource.Roster, VWResource.Roster);
            } else if (VWStringUtils.compare(category, VWResource.EventLog) == 0) {
                iconLabel = new JLabel(logIcon);
                VWAccessibilityHelper.setAccessibility(iconLabel, this, VWResource.EventLog, VWResource.EventLog);
            } else if (VWStringUtils.compare(category, VWResource.ApplicationSpace) == 0) {
                iconLabel = new JLabel(appSpaceIcon);
                VWAccessibilityHelper.setAccessibility(iconLabel, this, VWResource.ApplicationSpace, VWResource.ApplicationSpace);
            }
            if (iconLabel != null) {
                iconLabel.setOpaque(false);
                iconPanel.add((Component)iconLabel, "Before");
            }
            return iconPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createTopPanel(String name, String category, String type, int serverId) {
        try {
            Font aFont = this.getFont();
            Font boldFont = new Font(aFont.getName(), 1, aFont.getSize());
            JPanel topPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.fill = 2;
            gbConst.weightx = 0.0;
            gbConst.insets = new Insets(10, 4, 2, 4);
            JLabel label = new JLabel(VWResource.s_label.toString(VWResource.Name));
            label.setFont(boldFont);
            topPanel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, topPanel, VWResource.Name, VWResource.Name);
            gbConst.weightx = 1.0;
            gbConst.insets = new Insets(10, 4, 2, 4);
            JLabel nameControl = new JLabel(name);
            topPanel.add((Component)nameControl, gbConst);
            VWAccessibilityHelper.setAccessibility(nameControl, topPanel, name, name);
            gbConst.weightx = 0.0;
            gbConst.insets = new Insets(10, 40, 2, 4);
            label = new JLabel(VWResource.s_label.toString(VWResource.Category));
            label.setFont(boldFont);
            topPanel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, topPanel, VWResource.Category, VWResource.Category);
            gbConst.weightx = 1.0;
            gbConst.insets = new Insets(10, 4, 2, 10);
            gbConst.gridwidth = 0;
            JLabel categoryControl = new JLabel(category);
            topPanel.add((Component)categoryControl, gbConst);
            VWAccessibilityHelper.setAccessibility(categoryControl, topPanel, category, category);
            gbConst.weightx = 0.0;
            gbConst.insets = new Insets(2, 4, 10, 4);
            gbConst.gridwidth = 1;
            label = new JLabel(VWResource.s_label.toString(VWResource.ServerID));
            label.setFont(boldFont);
            topPanel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, topPanel, VWResource.ServerID, VWResource.ServerID);
            gbConst.insets = new Insets(2, 4, 10, 4);
            gbConst.weightx = 1.0;
            JLabel serverControl = new JLabel();
            if (serverId < 0) {
                serverControl.setText(VWResource.OnAllServers);
            } else {
                serverControl.setText(Integer.toString(serverId));
            }
            topPanel.add((Component)serverControl, gbConst);
            VWAccessibilityHelper.setAccessibility(serverControl, topPanel, serverControl.getText(), serverControl.getText());
            if (type != null) {
                gbConst.weightx = 0.0;
                gbConst.insets = new Insets(2, 40, 10, 4);
                label = new JLabel(VWResource.s_label.toString(VWResource.Type));
                label.setFont(boldFont);
                topPanel.add((Component)label, gbConst);
                VWAccessibilityHelper.setAccessibility(label, topPanel, VWResource.Type, VWResource.Type);
                gbConst.weightx = 1.0;
                gbConst.gridwidth = 0;
                gbConst.insets = new Insets(2, 4, 10, 10);
                JLabel typeControl = new JLabel(type);
                topPanel.add((Component)typeControl, gbConst);
                VWAccessibilityHelper.setAccessibility(typeControl, topPanel, type, type);
            }
            return topPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createDescriptionPanel(String description) {
        try {
            JPanel descriptionPanel = new JPanel(new BorderLayout(4, 4));
            Dimension dim = VWStringUtils.stringToDimension("335,225");
            if (dim == null) {
                dim = new Dimension(300, 200);
            }
            descriptionPanel.setPreferredSize(dim);
            JLabel label = new JLabel(VWResource.s_label.toString(VWResource.Description));
            descriptionPanel.add((Component)label, "First");
            VWAccessibilityHelper.setAccessibility(label, descriptionPanel, VWResource.Description, VWResource.Description);
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.addKeyListener(VWKeyAdapter.s_keyAdapter);
            JTextArea.setDefaultLocale(Locale.getDefault());
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.m_descriptionTextArea.applyComponentOrientation(compOrientation);
            if (description != null) {
                this.m_descriptionTextArea.setText(description);
            }
            descriptionPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextArea, descriptionPanel, VWResource.DescriptionTextArea, VWResource.DescriptionTextArea);
            VWAccessibilityHelper.setLabelFor(label, this.m_descriptionTextArea);
            return descriptionPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

